<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_galleries_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.galleries.gallery.delete')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/galleries.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.content'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_galleries_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.galleries.gallery.index'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_galleries_delete', ['id' => $gallery->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.galleries.gallery.delete'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite') ?>
<?php echo $view['translator']->trans('galleries.gallery.index.title'); ?> - <?php echo $view['translator']->trans('galleries.gallery.delete.title'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-camera-1 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
<?php echo $view['translator']->trans('galleries.gallery.delete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>

<?php echo $view['form']->start($form) ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-folder-2"></i><span><?php echo $view['translator']->trans('galleries.gallery.delete.subtitle'); ?> - <?php echo $gallery->getTitle(); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $view['translator']->trans('galleries.gallery.delete.question'); ?></strong></p>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($form['delete']); ?>
                    <?php echo $view['form']->widget($form['delete']); ?>
                </div>

                <button type="submit" id="AdminDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i>
                    <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>

                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_galleries_index', [
                    'id' => ($gallery->getParent() ? $gallery->getParent()->getId() : null),
                ]); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
            </div>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form) ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/galleries.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
