<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_faq_question_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.category.catDelete')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/faq.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.faq'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_category_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.category.catList'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_category_delete', array('id' => $category->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.category.catDelete'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    
    <?php echo $view['translator']->trans('faqQuestion.listTitle'); ?> - <?php echo $view['translator']->trans('catDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-help-circled-1 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('catDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title">
            <i class="icon-doc-remove"></i>
            <span><?php echo $view['translator']->trans('catDelete.listSubTitle'); ?> - <?php echo $category->getName(); ?></span>
        </h3></div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $view['translator']->trans('catDelete.listQuestions'); ?></strong></p>
                <p><strong><?php echo $view['translator']->trans('catDelete.confirm'); ?></strong></p>
                <?php echo $view['form']->start($deleteForm); ?>
                <?php echo $view['form']->errors($deleteForm); ?>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($deleteForm['deleteCategory']); ?>
                    <?php echo $view['form']->widget($deleteForm['deleteCategory']); ?>
                </div>
                <p><br>
                    <strong><?php echo $view['translator']->trans('categoryForm.name'); ?>:</strong> <?php echo $category->getName() ?><br>
                </p>
                <button type="submit" id="CategoryDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_faq_category_show', array('id' => $category->getId())); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
                <?php echo $view['form']->end($deleteForm); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/faq.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
