<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_product_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.ecommerce.product.show', [], 'ecommerce')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>"  rel="stylesheet">
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.product.index', [], 'ecommerce'); ?></a></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_show', ['id' => $product->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.product.show', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('ecommerce.product.index.title', [], 'ecommerce'); ?> - <?php echo $view['translator']->trans('ecommerce.product.show.title', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?>
<i class="icon-shop color-menu-ecommerce"></i>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('ecommerce.product.show.desc', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel'); ?><?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-doc-add"></i>
            <span><?php echo $view['translator']->trans('ecommerce.product.show.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <div class="imgThumbnail <?php echo($product->getImage() ? "nonebackground" : "opacity-50"); ?>">
                    <?php if($image = $product->getImage('thumbnail')): ?>
                        <img class="thumbnail" src="<?php echo $view['assets']->getUrl($image); ?>" alt="<?php echo $product->getTitle(); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="large-10 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.table.title', [], 'ecommerce'); ?>:</strong>
                    <?php echo $product->getTitle(); ?>
                </p>
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.table.categories', [], 'ecommerce'); ?>:</strong>
                    <?php foreach ($product->getCategories() as $category): ?>
                    <span class="info label secondary showNewsButton"><?php echo $category->getTitle(); ?></span>
                    <?php endforeach; ?>
                </p>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('ecommerce.product.table.content', [], 'ecommerce'); ?>:</strong></p>
            </div>
            <div class="large-10 columns">
                <div class="showTinyPreview">
                    <textarea class="tinymceShowContent">
                        <?php echo $product->getContent(); ?>
                    </textarea>
                </div>
                <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('admin_ecommerce_product_edit', ['id' => $product->getId()]); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                        <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                    </a>
                <?php endif; ?>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('admin_ecommerce_product_index'); ?>"><i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?></a>
            </div>
        </div>
    </div>
</div>

<?php echo $view->render('Components/modalTinyMCE.html.php'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js'); ?>'></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
