<tr class="option-field-row" data-id="<?php echo $option->getId(); ?>">
    <td><label class="middle"><?php echo $option->getLabel(); ?></label></td>
    <td>
        <div class="switch">
            <input type="checkbox" name="options[<?php echo $option->getId(); ?>][visible]" id="options-visible-<?php echo $option->getId(); ?>" class="switch-input" value="1" <?php echo isset($visible) && $visible == 1 ? 'checked' : null; ?>>
            <label class="switch-paddle" for="options-visible-<?php echo $option->getId(); ?>">
                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
            </label>
        </div>
    </td>
    <td>
        <input type="hidden" name="options[<?php echo $option->getId(); ?>][id]" value="<?php echo isset($id) ? $id : null; ?>">
        <?php if ($option->getType() === 'select'): ?>
            <select name="options[<?php echo $option->getId(); ?>][value]">
                <?php foreach ($option->getDefaultValues() as $val): ?>
                    <option value="<?php echo $val; ?>" <?php echo isset($value) && $val == $value ? 'selected' : null; ?>><?php echo $val; ?></option>
                <?php endforeach; ?>
            </select>
        <?php elseif ($option->getType() === 'checkbox'): ?>
            <div class="switch">
                <input type="checkbox" name="options[<?php echo $option->getId(); ?>][value]" id="options-<?php echo $option->getId(); ?>" class="switch-input" value="1" <?php echo isset($value) && $value == 1 ? 'checked' : null; ?>>
                <label class="switch-paddle" for="options-<?php echo $option->getId(); ?>">
                    <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                    <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                </label>
            </div>
        <?php else: ?>
            <input type="text" name="options[<?php echo $option->getId(); ?>][value]" value="<?php echo isset($value) ? $value : implode(',', $option->getDefaultValues()); ?>">
        <?php endif; ?>
    </td>
    <td><a class="button alert option-field-remove-row" title="<?php echo $view['translator']->trans('Table.deleteButton'); ?>"><i class="icon-cancel-circled-outline"></i></a></td>
</tr>
