<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_order_index'));
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];

$view['slots']->set('title', $translator->trans('title.ecommerce.order.show', [], 'ecommerce'));
$view['slots']->set('titleSite', $translator->trans('ecommerce.order.show.title', [], 'ecommerce'));
$view['slots']->set('titleDesc', $translator->trans('ecommerce.order.show.desc', [], 'ecommerce'));
$view['slots']->set('titleIcon', '<i class="icon-basket color-menu-ecommerce"></i>');
$view['slots']->set('helpRightPanel', '');
?>
<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $configHelper->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_order_index'); ?>"><?php echo $translator->trans('breadcrumbs.ecommerce.order.index', [], 'ecommerce'); ?></a></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_order_show', ['id' => $order->getId()]); ?>"><?php echo $translator->trans('breadcrumbs.ecommerce.order.show', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-basket"></i>
            <span><?php echo $translator->trans('ecommerce.order.show.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="medium-5 columns">
                <h6>Dane:</h6>
                <address>
                    <?php if ($order->getName()): ?>
                        <strong><?php echo $order->getName(); ?></strong><br>
                    <?php endif; ?>
                    <?php echo $translator->trans('ecommerce.order.table.email', [], 'ecommerce'); ?>: <?php echo $order->getEmail() ? : '—'; ?><br>
                    <?php echo $translator->trans('ecommerce.order.table.phone', [], 'ecommerce'); ?>: <?php echo $order->getPhone() ? : '—'; ?>
                </address>
            </div>
            <div class="medium-7 columns">
                <h6>Wiadomość</h6>
                <div class="callout"><?php echo nl2br($order->getMessage()); ?></div>
            </div>
        </div>
        <br>
        <table class="inventory">
            <thead>
                <th><?php echo $translator->trans('ecommerce.order.table.lp', [], 'ecommerce'); ?></th>
                <th><?php echo $translator->trans('ecommerce.order.table.product', [], 'ecommerce'); ?></th>
            </thead>
            <tbody>
                <?php /** @var \Admin\EcommerceBundle\Entity\OrderDetail $detail */
                foreach ($order->getDetails() as $i => $detail): ?>
                <tr>
                    <td><?php echo $i+1; ?></td>
                    <td><a href="<?php echo $view['router']->url('admin_ecommerce_product_show', ['id' => $detail->getProductId()]); ?>" target="_blank"><?php echo $detail->getName(); ?> <i class="icon-link-ext"></i></a></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <a class="button secondary float-right" href="<?php echo $view['router']->path('admin_ecommerce_order_index'); ?>"><i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?></a>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
