<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_order_index'));
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];

$view['slots']->set('title', $translator->trans('title.ecommerce.order.index', [], 'ecommerce'));
$view['slots']->set('titleSite', $translator->trans('ecommerce.order.index.title', [], 'ecommerce'));
$view['slots']->set('titleDesc', $translator->trans('ecommerce.order.index.desc', [], 'ecommerce'));
$view['slots']->set('titleIcon', '<i class="icon-basket color-menu-ecommerce"></i>');
$view['slots']->set('helpRightPanel', '');
?>
<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $configHelper->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_order_index'); ?>"><?php echo $translator->trans('breadcrumbs.ecommerce.order.index', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-basket"></i>
            <span><?php echo $translator->trans('ecommerce.order.index.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns tableResp">
                <table id="productList" class="display" style="width:100%">
                    <thead>
                    <tr>
                        <th><?php echo $translator->trans('ecommerce.order.table.id', [], 'ecommerce'); ?></th>
                        <th><?php echo $translator->trans('ecommerce.order.table.name', [], 'ecommerce'); ?></th>
                        <th><?php echo $translator->trans('ecommerce.order.table.email', [], 'ecommerce'); ?></th>
                        <th><?php echo $translator->trans('ecommerce.order.table.phone', [], 'ecommerce'); ?></th>
                        <th><?php echo $translator->trans('ecommerce.order.table.created_at', [], 'ecommerce'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php /** @var \Admin\EcommerceBundle\Entity\Order $order */
                    foreach ($orders as $order): ?>
                        <tr>
                            <td><?php echo $order->getId(); ?></td>
                            <td><?php echo $order->getName(); ?></td>
                            <td>
                                <a href="<?php echo $view['router']->path('admin_ecommerce_product_show', ['id' => $order->getId()]); ?>"><b><?php echo $order->getEmail(); ?></b></a>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <a href="<?php echo $view['router']->path('admin_ecommerce_order_show', ['id' => $order->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $translator->trans('Table.showButton'); ?></a>
                                    </div>
                                </div>
                            </td>
                            <td><?php echo $order->getPhone(); ?></td>
                            <td><?php echo $order->getCreatedAt()->format('H:i:s d.m.Y'); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="medium-6 columns"></div>
            <div class="medium-6 columns paginationBox">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                    'knp_pagination' => $orders,
                ]); ?>
                <?php echo $view['knp_pagination']->render($orders); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
