<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_product_option_index'));
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];

$view['slots']->set('title', $translator->trans('title.ecommerce.option.edit', [], 'ecommerce'));
$view['slots']->set('titleSite', $translator->trans('ecommerce.option.edit.title', [], 'ecommerce'));
$view['slots']->set('titleDesc', $translator->trans('ecommerce.option.edit.desc', [], 'ecommerce'));
$view['slots']->set('titleIcon', '<i class="icon-list-1 color-menu-ecommerce"></i>');
$view['slots']->set('helpRightPanel', '');
?>
<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tagify/tagify.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $configHelper->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_option_index'); ?>"><?php echo $translator->trans('breadcrumbs.ecommerce.option.index', [], 'ecommerce'); ?></a></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_option_edit', ['id' => $option->getId()]); ?>"><?php echo $translator->trans('breadcrumbs.ecommerce.option.edit', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-newspaper-1"></i>
            <span><?php echo $translator->trans('ecommerce.option.edit.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('ecommerce.option.form.label.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('ecommerce.option.form.label.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['label']); ?></div>
                <?php echo $view['form']->widget($form['label'], [
                    'attr' => [
                        'class' => ($form['label']->vars['attr']['class'] ?? '') . (! $form['label']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('ecommerce.option.form.type.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('ecommerce.option.form.type.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['type']); ?></div>
                <?php echo $view['form']->widget($form['type'], [
                    'attr' => [
                        'class' => ($form['type']->vars['attr']['class'] ?? '') . (! $form['type']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('ecommerce.option.form.default_values.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('ecommerce.option.form.default_values.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['defaultValues']); ?></div>
                <?php echo $view['form']->widget($form['defaultValues'], [
                    'attr' => [
                        'class' => ($form['defaultValues']->vars['attr']['class'] ?? '') . (! $form['defaultValues']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i> <?php echo $translator->trans('Form.send'); ?></button>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('admin_ecommerce_product_option_index'); ?>"><i class="icon-reply"></i> <?php echo $translator->trans('Form.backShow'); ?></a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tagify/tagify.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<script>
    var tagify = new Tagify($('[name*=defaultValues]')[0]);
</script>
<?php $view['slots']->stop(); ?>
