<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_category_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.ecommerce.category.show', [], 'ecommerce')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>"  rel="stylesheet">
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_category_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.category.index', [], 'ecommerce'); ?></a></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_category_show', ['id' => $category->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.category.show', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('ecommerce.category.index.title', [], 'ecommerce'); ?> - <?php echo $view['translator']->trans('ecommerce.category.show.title', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?>
<i class="icon-folder-open-2 color-menu-ecommerce"></i>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('ecommerce.category.show.desc', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel'); ?><?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-folder-add"></i>
            <span><?php echo $view['translator']->trans('ecommerce.category.show.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <div class="imgThumbnail <?php echo($category->getImage() ? "nonebackground" : "opacity-50"); ?>">
                    <?php if($image = $category->getImage('thumbnail')): ?>
                        <img class="thumbnail" src="<?php echo $view['assets']->getUrl($image); ?>" alt="<?php echo $category->getTitle(); ?>">
                    <?php endif; ?>
                </div>
            </div>
            <div class="large-10 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.category.table.title', [], 'ecommerce'); ?>:</strong>
                    <?php echo $category->getTitle(); ?>
                </p>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('ecommerce.category.table.content', [], 'ecommerce'); ?>:</strong></p>
            </div>
            <div class="large-10 columns">
                <div class="showTinyPreview">
                    <textarea class="tinymceShowContent">
                        <?php echo $category->getContent(); ?>
                    </textarea>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns"></div>
            <div class="large-10 columns">
                <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                <a href="<?php echo $view['router']->path('admin_ecommerce_category_edit', ['id' => $category->getId()]); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                    <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="columns">
        <a class="button secondary float-right" href="<?php echo $view['router']->path('admin_ecommerce_category_index'); ?>">
            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
        </a>
    </div>
</div>

<?php echo $view->render('Components/modalTinyMCE.html.php'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js'); ?>'></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
