<?php $showLink = $view['router']->path('admin_ecommerce_category_show', ['id' => $category->getId()]); ?>
<tr>
    <td class="td-title"><div><?php echo $prefix; ?><span class="cat-prefix">&nbsp;</span><a href="<?php echo $showLink; ?>" class="title" title="<?php echo $category->getTitle(); ?>"><?php echo $category->getTitle(); ?></a></div></td>
    <td>
        <div class="buttonItemsBox">
            <div class="buttonsItems">
                <a href="<?php echo $showLink; ?>"><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a>
                <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                    | <a href="<?php echo $view['router']->path('admin_ecommerce_category_edit', ['id' => $category->getId()]); ?>"><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton') ?></a>
                    | <a href="<?php echo $view['router']->path('admin_ecommerce_category_delete', ['id' => $category->getId()]); ?>"><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </td>
    <td><?php echo $category->getShortDescription(); ?></td>
    <td class="td-order">
        <div class="OrderNrForm">
            <?php echo $prefix; ?>
            <?php if ($hasPrev): ?>
                <a href="<?php echo $view['router']->path('admin_ecommerce_category_update_order', ['id' => $category->getId(), 'sort_dir' => 'up']); ?>" class="button secondary tiny button-category-move"><i class="icon-up-dir margin-center"></i></a>
            <?php else: ?>
                <span class="button disabled secondary tiny button-category-move"><i class="icon-up-dir margin-center"></i></span>
            <?php endif; ?>
            <?php if ($hasNext): ?>
                <a href="<?php echo $view['router']->path('admin_ecommerce_category_update_order', ['id' => $category->getId(), 'sort_dir' => 'down']); ?>" class="button secondary tiny button-category-move"><i class="icon-down-dir margin-center"></i></a>
            <?php else: ?>
                <span class="button disabled secondary tiny button-category-move"><i class="icon-down-dir margin-center"></i></span>
            <?php endif; ?>
        </div>
    </td>
</tr>
