<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_department_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.department.index', [], 'department')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/department.css') ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $view['translator']->trans('main-menu.administration'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_department_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.department.index', [], 'department'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?><?php echo $view['translator']->trans('department.index.title', [], 'department'); ?><?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleDesc'); ?><?php echo $view['translator']->trans('department.index.desc', [], 'department'); ?><?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?><i class="icon-th-list-2 color-menu-administration"></i><?php $view['slots']->stop(); ?>
<?php $view['slots']->start('helpRightPanel'); ?><?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php
$displayTree = function ($departments, $prefix = '', $html = '') use (&$displayTree, $view) {
    foreach ($departments as $department) {
        $html .= '
            <tr>
                <td>'.$department->getId().'</td>
                <td>'.$prefix.'<span class="cat-prefix">&nbsp;</span><a href="'.$view['router']->path('wi_admin_department_edit', ['id' => $department->getId()]).'" class="title">'.$department->getTitle().'</a></td>
                <td>
                    <div class="buttonItemsBox">
                        <div class="buttonsItems">
                            <a href="'.$view['router']->path('wi_admin_department_edit', ['id' => $department->getId()]).'"><i class="icon-edit-1"></i>'.$view['translator']->trans('Table.editButton').'</a>
                        </div>
                    </div>
                </td>
            </tr>
        ';

        // Jeśli, są poddziały.
        if ($department->getChildren()->count()) {
            $html .= $displayTree($department->getChildren(),$prefix.'<span class="cat-prefix">&nbsp;</span>');
        }
    }

    return $html;
};
?>

<div class="box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <a href="<?php echo $view['router']->path('wi_admin_department_new'); ?>" class="button tiny primary buttonAddNew"><i class="icon-plus"></i><?php echo $view['translator']->trans('department.new.title', [], 'department'); ?></a>
        </div>
        <h3 class="box-title">
            <i class="icon-th-list-2"></i><span><?php echo $view['translator']->trans('department.index.subtitle', [], 'department'); ?></span>
        </h3>
    </div>

    <div class="box-body" style="display:block;">
        <div class="row">
            <div class="columns tableResp">
                <table id="departmentList" class="departmentList row-border unstriped hover" style="width: 100%">
                    <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('department.table.id', [], 'department'); ?></th>
                            <th><?php echo $view['translator']->trans('department.table.title', [], 'department'); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php echo $displayTree($departments); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/department.js'); ?>"></script>
<?php $view['slots']->stop(); ?>