<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_contact_index')); ?>
<?php $view['form']->setTheme($form, [':form_errors']); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.contact.new')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/contact.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li><?php echo $view['translator']->trans('main-menu.micro_web_crm'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_contact_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.contact.index'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_contact_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.contact.new'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('contact.title'); ?> - <?php echo $view['translator']->trans('contact.titleNew'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-edit color-menu-micro-web-crm"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('contact.descNew'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/contact.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-edit"></i>
            <span><?php echo $view['translator']->trans('contactNew.title'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['form']->label($form['name']); ?></strong></p>
            </div>
            <div class="large-10 columns">

                <div class="row">
                    <div class="columns medium-8 large-6">
                        <?php echo $view['form']->widget($form['name']); ?>
                        <?php echo $view['form']->errors($form['name']); ?>
                    </div>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['form']->label($form['type']); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('contactNew.formDesc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="columns medium-8 large-6">
                        <div class="callout small alert hide choseTypeValidInfo">
                            <?php echo $view['translator']->trans('contactNew.valid'); ?>
                        </div>
                        <?php echo $view['form']->widget($form['type']); ?>
                        <?php echo $view['form']->errors($form['type']); ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="columns">
        <button class="button" type="submit" value="<?php echo $view['translator']->trans('contactNew.save'); ?>">
            <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
        </button>

        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_contact_index'); ?>">
            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
        </a>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop() ?>
