<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_wicms_config_security'));

/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];

$view['slots']->set('title', $translator->trans('configuration.meta.title', [], 'config'));
$view['slots']->set('titleSite', $translator->trans('configuration.security.title', [], 'config'));
$view['slots']->set('titleDesc', $translator->trans('configuration.security.desc', [], 'config'));
$view['slots']->set('titleIcon', '<i class="icon-lock color-menu-configuration"></i>');
$view['slots']->set('helpRightPanel', '');
?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/configuration.css'); ?><?php echo $configHelper->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $translator->trans('main-menu.configuration.title'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_wicms_config_security'); ?>"><?php echo $translator->trans('breadcrumbs.configuration_security', [], 'config'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-cogs"></i>
                <span><?php echo $view['translator']->trans('configuration.security.ips', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-4 columns">
                    <p>
                        <strong><?php echo $translator->trans('configuration.security.form.attempt_count.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('configuration.security.form.attempt_count.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-8 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['block_attemptCount']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['block_attemptCount'], [
                        'attr' => [
                            'class' => ($form['block_attemptCount']->vars['attr']['class'] ?? '') . (! $form['block_attemptCount']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-4 columns">
                    <p>
                        <strong><?php echo $translator->trans('configuration.security.form.time_count.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('configuration.security.form.time_count.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-8 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['block_timeCount']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['block_timeCount'], [
                        'attr' => [
                            'class' => ($form['block_timeCount']->vars['attr']['class'] ?? '') . (! $form['block_timeCount']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-4 columns">
                    <p>
                        <strong><?php echo $translator->trans('configuration.security.form.ip.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('configuration.security.form.ip.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-8 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['block_ipTime']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['block_ipTime'], [
                        'attr' => [
                            'class' => ($form['block_ipTime']->vars['attr']['class'] ?? '') . (! $form['block_ipTime']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                    <?php echo $view['form']->widget($form['block_ipTimeUnit'], [
                        'attr' => [
                            'class' => ($form['block_ipTimeUnit']->vars['attr']['class'] ?? '') . (! $form['block_ipTimeUnit']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-4 columns">
                    <p>
                        <strong><?php echo $translator->trans('configuration.security.form.user.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('configuration.security.form.user.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-8 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['block_userTime']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['block_userTime'], [
                        'attr' => [
                            'class' => ($form['block_userTime']->vars['attr']['class'] ?? '') . (! $form['block_userTime']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                    <?php echo $view['form']->widget($form['block_userTimeUnit'], [
                        'attr' => [
                            'class' => ($form['block_userTimeUnit']->vars['attr']['class'] ?? '') . (! $form['block_userTimeUnit']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>

            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
        </div>
    </div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/configuration.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
