<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_config_news')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('configuration.meta.title', [], 'config')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/jqueryUI-datetimepicker/jquery-ui-1.12.1.custom/jquery-ui.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/configuration.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li>
    <?php echo $view['translator']->trans('main-menu.configuration.title'); ?>
</li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_config_ga'); ?>"><?php echo $view['translator']->trans('breadcrumbs.configuration_ga', [], 'config'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('configuration.ga.title', [], 'config'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-chart-bar color-menu-configuration"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>

<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-chart-bar-2"></i>
                <span><?php echo $view['translator']->trans('configuration.ga.title', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.ga.gaTracking.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.ga.gaTracking.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['google_gaTracking']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['google_gaTracking'], [
                        'attr' => [
                            'class' => $form['google_gaTracking']->vars['attr']['class'] . (! $form['google_gaTracking']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.ga.gaViewId.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.ga.gaViewId.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['google_gaViewId']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['google_gaViewId'], [
                        'attr' => [
                            'class' => $form['google_gaViewId']->vars['attr']['class'] . (! $form['google_gaViewId']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.ga.gaJson.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.ga.gaJson.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['google_gaJson']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['google_gaJson']); ?>
                    <?php if (! is_null($gaJson)): ?>
                        <p><?php echo $view['translator']->trans('configuration.ga.gaJson.descOK', [], 'config'); ?>: <?php echo $gaJson; ?></p>
                    <?php endif; ?>

                    <?php if (! is_null($googleTokenInfo)): ?>
                        <div class="callout alert small"><?php echo $googleTokenInfo; ?></div>
                    <?php endif; ?>
                </div>
            </div>
            <p class="text-center"><button class="button float-center secondary tiny" data-open="userManual" type="button"><?php echo $view['translator']->trans('configuration.ga.userManual.button', [], 'config'); ?></button></p>
            <div class="reveal large" id="userManual" data-reveal>
                <h4>Instrukcja włączania generowania statystyk dla Twojej strony internetowej</h4>
                <h5>1. Pobierz kod do śledzenia Google Analytics</h5>
                <ol>
                    <li>
                        Zaloguj się na stronie <a href="https://www.google.com/analytics/" target="_blank">Google Analytics</a>
                    </li>
                    <li>Jeśli w panelu Google Analytics nie jest dostępna Twoja strony dodaj ją:
                        <ul>
                            <li>Przejdź do Administracji i wybierz Twoje konto (lub dodaj konto)</li>
                            <li>Następnie w Administracji wybierz Usługi i Utwórz nową usługę</li>
                            <li>Postępuj zgodnie z instrukcjami wyświetlonymi w Panelu dodawania nowej usługi.</li>
                        </ul>
                    </li>
                    <li>Jeśli Twoja strona jest już dodana w Google Analytics pobierz kod śledzenia:
                        <ul>
                            <li>
                                Przejdź do Administracji w Google Analytics
                            </li>
                            <li>Wybierz swoje konto i swoją usługę (stronę internetową)</li>
                            <li>Kliknij link "Informacje o śledzeniu", a następnie "Kod śledzenia"</li>
                            <li>Skopiuj Globalny tag witryny (gtag.js) i wklej go w WiCMS w ustawieniach Google Analytics w polu Google Analytics - kod śledzenia</li>
                        </ul>
                    </li>
                </ol>
                <h5>2. Pobierz ID Widoku dla którego chcesz zobaczyć statystyki</h5>
                <ol>
                    <li>Zaloguj się na stronie <a href="https://www.google.com/analytics/" target="_blank">Google Analytics</a></li>
                    <li>Przejdź do Administracji konta, wybierz swoje konto i usługę (stronę internetową)</li>
                    <li>Wybierz Twój Widok danych, a następnie kliknij "Ustawienia widoku"</li>
                    <li>Skopiuj Identyfikator widoku danych i wklej go w WiCMS w ustawieniach Google Analytics w polu Google Analytics - Widok ID z Google Analytics</li>
                </ol>
                <h5>3. Pobierz plik JSON z Twojego konta Google API</h5>
                <ol>
                    <li>
                        Zaloguj się do Twojego konta <a href="https://console.developers.google.com/" target="_blank">Google API</a>
                    </li>
                    <li>Wybierz projekt z dostępnych w koncie lub dodaj nowy projekt</li>
                    <li>Dodaj Bibliotekę Analytics API:
                        <ul>
                            <li>Wybierz z menu Biblioteka</li>
                            <li>Znajdzie i wybierz bibliotekę Analytics API</li>
                            <li>Po przejściu w szczegóły kliknij przycisk Włącz</li>
                        </ul>
                    </li>
                    <li>Utwórz konto usługi:
                        <ul>
                            <li>Przejdź w menu głównym do Administracji</li>
                            <li>W Administracji wybierz Konta usługi</li>
                            <li>Kliknij Utwórz konto usługi</li>
                            <li>Wybierz nazwę oraz rolę usługi (Właściciel)</li>
                            <li>Zatwierdź nową usługę</li>
                        </ul>
                    </li>
                    <li>Dodaj dane logowania do Twojego konta:
                        <ul>
                            <li>Wybierz z menu Dane logowania</li>
                            <li>Kliknij przycisk Utwórz dane logowania</li>
                            <li>Wybierz opcję "Klucz konta usługi"</li>
                            <li>Wybierz konto usługi oraz typ klucza JSON</li>
                            <li>Kliknij Utwórz</li>
                            <li>Na komputerze zapisał się Twój plik JSON</li>
                        </ul>
                    </li>
                    <li>Wybierz pobrany plik JSON w WiCMS w ustawieniach Google Analytics w polu Plik JSON dla Twojego konta Google API</li>
                    <li>Potwierdź formularz ustawień Google Analytics w WiCMS</li>
                </ol>
                <h5>4. Połącz swoje konto Google Analytics z Google API</h5>
                <ol>
                    <li>
                        Zaloguj się do konta Twojego konta <a href="https://console.developers.google.com/" target="_blank">Google API</a>
                    </li>
                    <li>
                        Przejść do Administracji i kliknij Konta usługi
                    </li>
                    <li>
                        Zaznacz i skopiuj Identyfikator konta usługi
                    </li>
                    <li>
                        Zaloguj się na stronie <a href="https://www.google.com/analytics/" target="_blank">Google Analytics</a>
                    </li>
                    <li>
                        Przejdź do Administracji
                    </li>
                    <li>
                        Wybierz swoje konto, usługę oraz widok (widok ten sam, który wcześniej wkleiłeś w WiCMS)
                    </li>
                    <li>
                        Kliknij Zarządzanie użytkownikami
                    </li>
                    <li>Dodaj nowego użytkownika:
                        <ul>
                            <li>
                                W polu adres e-mail wklej identyfikator skopiowany z konta Google API
                            </li>
                            <li>
                                Wybierz role użytkownika (Odczyt i analiza)
                            </li>
                            <li>
                                Potwierdź przyciskiem Add
                            </li>
                        </ul>
                    </li>
                </ol>
                <h5>Przetestuj raport Google Analytics w WiCMS</h5>
                <ol>
                    <li>
                        Przejdź w Twoim WiCMS do Administracji i kliknij w menu Google Analytics
                    </li>
                    <li>
                        Powinien wyświetlić się raport pobrany z Google Analytics
                    </li>
                    <li>
                        Jeśli dane się nie wczytują, sprawdź czy poprawnie wykonałeś wszystkie kroki tej instrukcji
                    </li>
                    <li>
                        Jeśli Twoje konto jest dopiero utworzone, poczekaj kilka dni aż Google Analytics zbierze nowe dane
                    </li>
                </ol>
                <br>
                <button class="close-button" data-close aria-label="Close modal" type="button">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        </div>
    </div>
<div class="row">
    <div class="columns">
        <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
            <i class="icon-edit"></i>
            <?php echo $view['translator']->trans('Form.send'); ?>
        </button>
        <a href="<?php echo $view['router']->path('wi_admin_core_analytics_index') ?>" class="button secondary float-right">
            <i class="icon-chart-bar-2"></i>
            <?php echo $view['translator']->trans('configuration.ga.gaJson.showStatic', [], 'config'); ?>
        </a>
    </div>
</div>
<?php echo $view['form']->end($form); ?>

<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/xml/xml.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/javascript/javascript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/css/css.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/vbscript/vbscript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/htmlmixed/htmlmixed.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/jqueryUI-datetimepicker/jquery-ui-1.12.1.custom/jquery-ui.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/configuration.js'); ?>"></script>

<?php $view['slots']->stop(); ?>
