<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_config_news')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('configuration.meta.title', [], 'config')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/configuration.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $view['translator']->trans('main-menu.configuration.title'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_core_config_contact'); ?>"><?php echo $view['translator']->trans('breadcrumbs.configuration_contact', [], 'config'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('configuration.contact.title', [], 'config'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-edit color-menu-configuration"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-chart-bar-2"></i>
                <span><?php echo $view['translator']->trans('configuration.contact.title', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contact.googleApiKey.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contact.googleApiKey.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['google_apiKey']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['google_apiKey'], [
                        'attr' => [
                            'class' => $form['google_apiKey']->vars['attr']['class'] . (! $form['google_apiKey']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contact.googleRecaptchaSiteKey.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contact.googleRecaptchaSiteKey.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['recaptcha_siteKey']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['recaptcha_siteKey'], [
                        'attr' => [
                            'class' => $form['recaptcha_siteKey']->vars['attr']['class'] . (! $form['recaptcha_siteKey']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contact.googleRecaptchaSecretKey.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contact.googleRecaptchaSecretKey.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['recaptcha_secretKey']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['recaptcha_secretKey'], [
                        'attr' => [
                            'class' => $form['recaptcha_secretKey']->vars['attr']['class'] . (! $form['recaptcha_secretKey']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
        </div>
    </div>
<?php echo $view['form']->end($form); ?>

<?php echo $view['form']->start($formContact); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-chart-bar-2"></i>
                <span><?php echo $view['translator']->trans('configuration.contactConfig.title', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contactConfig.companyName.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contactConfig.companyName.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($formContact['contact_companyName']); ?>
                    </div>
                    <?php echo $view['form']->widget($formContact['contact_companyName'], [
                        'attr' => [
                            'class' => $formContact['contact_companyName']->vars['attr']['class'] . (! $formContact['contact_companyName']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contactConfig.address.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contactConfig.address.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($formContact['contact_address']); ?>
                    </div>
                    <?php echo $view['form']->widget($formContact['contact_address'], [
                        'attr' => [
                            'class' => $formContact['contact_address']->vars['attr']['class'] . (! $formContact['contact_address']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contactConfig.street.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contactConfig.street.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($formContact['contact_street']); ?>
                    </div>
                    <?php echo $view['form']->widget($formContact['contact_street'], [
                        'attr' => [
                            'class' => $formContact['contact_street']->vars['attr']['class'] . (! $formContact['contact_street']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contactConfig.email.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contactConfig.email.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($formContact['contact_email']); ?>
                    </div>
                    <?php echo $view['form']->widget($formContact['contact_email'], [
                        'attr' => [
                            'class' => $formContact['contact_email']->vars['attr']['class'] . (! $formContact['contact_email']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contactConfig.phone.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contactConfig.phone.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($formContact['contact_phone']); ?>
                    </div>
                    <?php echo $view['form']->widget($formContact['contact_phone'], [
                        'attr' => [
                            'class' => $formContact['contact_phone']->vars['attr']['class'] . (! $formContact['contact_phone']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contactConfig.logo.titleA', [], 'config'); ?></strong></p>
                </div>
                <div class="large-10 columns">
                    <div class="actualIcon">
                        <img src="<?php echo $view['assets']->getUrl('media/Public/img/logo/' . $view['config']->get('contact.logo')); ?>" alt="">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.contactConfig.logo.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contactConfig.logo.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($formContact['contact_logo']); ?>
                    </div>
                    <?php echo $view['form']->widget($formContact['contact_logo'], [
                    ]);
                    ?>
                </div>
            </div>
            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
<?php echo $view['translator']->trans('Form.send'); ?>
            </button>
        </div>
    </div>
<?php echo $view['form']->end($formContact); ?>

<?php echo $view['form']->start($getallForm); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-edit"></i>
            <span><?php echo $view['translator']->trans('configuration.contact.getall.title', [], 'config'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('configuration.contact.getall.form.api_key.title', [], 'config'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.contact.getall.form.api_key.desc', [], 'config'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert">
                    <?php echo $view['form']->errors($getallForm['getall_apiKey']); ?>
                </div>
                <?php echo $view['form']->widget($getallForm['getall_apiKey'], [
                    'attr' => [
                        'class' => $getallForm['getall_apiKey']->vars['attr']['class'] . (! $getallForm['getall_apiKey']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
            <i class="icon-edit"></i>
            <?php echo $view['translator']->trans('Form.send'); ?>
        </button>
    </div>
</div>
<?php echo $view['form']->end($getallForm); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/lib/codemirror.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/xml/xml.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/javascript/javascript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/css/css.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/vbscript/vbscript.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/codemirror-5.32.0/mode/htmlmixed/htmlmixed.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/configuration.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
