<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>


<?php $view['slots']->set('title', $view['translator']->trans('title.campaign.campaignShow')) ?>


<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
<li><?php echo $view['translator']->trans('main-menu.micro_web_crm'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_show', ['id' => $campaign->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.campaign.campaignShow'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('campaign.listTitle'); ?> - <?php echo $view['translator']->trans('campaign.subTitleShow'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-mail color-menu-micro-web-crm"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('campaign.desc'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowNews-dropdown">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowNews-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_edit', array('id' => $campaign->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_delete', ['id' => $campaign->getId()]); ?>">
                                        <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('campaign.delete.boxTitle'); ?></span>
                                    </a>
                                </li>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <h3 class="box-title">
                <span><?php echo $view['translator']->trans('campaign.details'); ?> - <?php echo $campaign->getName(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('campaign.name'); ?>:</strong></p>
                </div>
                <div class="large-10 columns">
                    <p><?php echo $campaign->getName(); ?> </p>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-4 columns">
                    <p><strong><?php echo $view['translator']->trans('campaign.summary'); ?>:</strong></p>
                </div>
                <div class="large-8 columns">
                    <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_newsletter_messagecontent_new', ["id" => $campaign->getId()]); ?>" class="button tiny mRecipientsButton" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                            <i class="icon-doc-add"></i><?php echo $view['translator']->trans('campaign.newMessage'); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="row">
                <div class="large-4 columns">
                    <p><strong><?php echo $view['translator']->trans('campaign.messageT'); ?>:</strong></p>
                </div>
                <div class="large-8 columns">
                    <?php foreach ($campaign->getMessageContent() as $messageContent): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_newsletter_messagecontent_edit', ["id" => $messageContent->getId()]); ?>" class="info label secondary showNewsButton tiny" style="margin-bottom: 5px;">
                            <?php echo $messageContent->getTitle(); ?>
                        </a>
                    <?php endforeach ?>
                </div>
            </div>
            <hr>
            <?php foreach ($campaign->getMessageContent() as $message): ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><?php echo $message->getTitle() ?></p>
                    <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                        <p>
                            <a href="<?php echo $view['router']->path('wi_admin_newsletter_messagecontent_edit', ["id" => $message->getId()] ) ?>" title="<?php echo $view['translator']->trans('faqQuestionList.add'); ?>" class="button tiny mRecipientsButton">
                                <i class="icon-edit"></i> <?php echo $view['translator']->trans('campaign.editMessage'); ?>
                            </a>
                        </p>
                    <?php endif; ?>
                </div>
                <div class="large-10 columns">
                    <div class="callout message-paper">
                        <?php echo $message->getMessage() ?>
                    </div>
                </div>
            </div>
            <hr>
            <?php endforeach; ?>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_index', ['id' => $campaign->getId()]); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
