<div class="large-5 columns">
    <div class="box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configCampaign-dropdown-1">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configCampaign-dropdown-1" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_edit', ['id' => $campaign->getId()]); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_show', ['id' => $campaign->getId()]); ?>" title="<?php echo $view['translator']->trans('Form.show'); ?>">
                                    <span><i class="icon-eye"></i><?php echo $view['translator']->trans('Form.show'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <span>
                    <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                <span>Campaign status - </span>
                <?php if ($statistics['campaign_active']): ?>
                    <span class="statusIcon"><i class="icon-check statusB">ON</i></span>
                <?php else: ?>
                    <span class="statusIcon"><i class="icon-cancel statusB">OFF</i></span>
                <?php endif; ?>
            </h3>
        </div>
        <div class="box-body" style="display: block">
            <table id="statusBar" class="table-config" style="width: 100%">
                <tbody>
                    <tr>
                        <td><strong>Campaign status:</strong></td>
                        <td style="color: red;"><?php echo $statistics['info']; ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.range'); ?>:</strong></td>
                        <td><?php echo $statistics['date_range']; ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.contents'); ?>:</strong></td>
                        <td><?php echo $statistics['content_messages']; ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.recipients'); ?>:</strong></td>
                        <td><?php echo $statistics['recipients']; ?> (in <?php echo $statistics['recipient_groups']; ?> groups)</td>
                    </tr>
                    <tr>
                        <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.messagesS'); ?>:</strong></td>
                        <td><?php echo $statistics['messages_sent']; ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.messagesA'); ?>:</strong></td>
                        <td><?php echo $statistics['messages_awaiting']; ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php echo $view['translator']->trans('newsletter.blockContent.statusbar.sendersC'); ?>:</strong></td>
                        <td><?php echo $statistics['senders']; ?></td>
                    </tr>
                </tbody>
            </table>


            <div class="row">
                <div class="medium-6 columns">
                    <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_manual_start_campaing', ['id' => $campaign->getId()]); ?>"><span class="label button alert">Manually start the cycle</span></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
