<div class="large-6 columns">
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                </span>
            </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                    <span><?php echo $view['translator']->trans('newsletter.blocks.config'); ?></span>
                </h3>
        </div>
        <div class="box-body" style="display: none;">
            <table id="configInfo" class="table-config tableResp" style="width:100%">
                <thead>
                    <tr>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.config.paramName'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.config.paramValue'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.config.aidValue'); ?></th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($config as $key => $conf): ?>
                    <tr data-param-id="<?php echo $conf->getId(); ?>" data-param-name="<?php echo $conf->getParamName(); ?>" data-campaign-id="<?php echo $campaign->getId(); ?>">
                        <td id="paramName_<?php echo $conf->getId(); ?>"><?php echo $conf->getParamName(); ?></td>
                        <td><?php echo getForm($conf); ?></td>
                        <td>
                            <input type="text" class="inputConfig aidValue" id="aidValue_<?php echo $conf->getId(); ?>" value="<?php echo $conf->getAidValue(); ?>" disabled>
                        </td>
                        <td>
                            <div class="buttonItemsBox config">
                                <div class="buttonsItems config">
                                    <span class="ajax-edit">
                                        <i id="<?php echo $conf->getId(); ?>" class="icon-pencil <?php echo ($conf->getParamName() == 'days_of_week' ? 'icondDaysOfWeek' : null); ?>" data-campaign-id="<?php echo $campaign->getId(); ?>"></i>
                                    </span>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
function getForm($conf)
{
    switch ($conf->getParamName()) {
        case 'enable_campaign':
            // no break
        case 'randomize_messages':
            // no break
        case 'randomize_recipients':
            // no break
        case 'randomize_senders':
            $form = '
                <div class="switch tiny">
                    <input type="checkbox" class="inputConfig switch-input switchConfig" id="paramValue_'.$conf->getId().'" value="'.$conf->getParamValue().'" disabled '.(boolval($conf->getParamValue()) ? 'checked' : '').'>
                    <label class="switch-paddle labelSwitch" for="paramValue_'.$conf->getId().'">
                        <span class="show-for-sr">Enable newsletter</span>
                        <span class="switch-active" aria-hidden="true">ON</span>
                        <span class="switch-inactive" aria-hidden="true">OFF</span>
                    </label>
                </div>
            ';
            break;
        case 'quantity_to_sent':
            $form = '<input type="number" class="inputConfig quantity_to_sent" id="paramValue_'.$conf->getId().'" value="'.$conf->getParamValue().'" disabled>';
            break;
        case 'days_of_week':
            $days = [1 => 'Pn', 2 => 'Wt', 3 => 'Sr', 4 => 'Cz', 5 => 'Pt', 6 => 'So', 7 => 'Nd'];
            $form = '';

            for ($i = 1; $i <= 7; $i++) {
                $form .= '<label class="labelDaysOfWeek"><input type="checkbox" class="inputConfig checkboxDaysOfWeek" id="paramValue_'.$conf->getId().'_'.$i.'" value="'.$i.'" disabled '.(in_array($i, explode(',', $conf->getParamValue())) ? 'checked' : '').'>'.$days[$i].'</label>';
            }
            break;
        case 'date_end':
            // no break
        case 'date_start':
            $form = '<input type="text" class="inputConfig '.$conf->getParamName().'" id="paramValue_'.$conf->getId().'" value="'.$conf->getParamValue().'" disabled>';
            break;
        default:
            $form = '<input type="text" class="inputConfig quantity_to_sent" id="paramValue_'.$conf->getId().'" value="'.$conf->getParamValue().'" disabled>';
            break;
    }

    return $form;
}
?>
