<div class="large-6 columns">
    <!--SENDERS LIST-->
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configNews-dropdown2">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configNews-dropdown2" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_new', ['cid'=>$campaign->getId()]); ?>"  title="Create new sender">
                                    <span><i class="icon-folder-add"></i>Create new sender</span>
                                </a>
                            </li>
                            <li>
                                <a data-open="addSenderModal">
                                    <span><i class="icon-folder-add"></i>Add/Remove senders</span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <span>
                    <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-paper-plane-empty"></i>
                <span><?php echo $view['translator']->trans('newsletter.blocks.senders'); ?></span>
            </h3>
        </div>
        <!-- /.box-body -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="columns end tableResp">
                    <table id="sendersList" class="table-config tableResp" style="width:100%">
                        <thead>
                            <tr>
                                <th><?php echo $view['translator']->trans('newsletter.blockContent.senders.email'); ?></th>
                                <th><?php echo $view['translator']->trans('newsletter.blockContent.senders.name'); ?></th>
                                <th class="langStyle"><?php echo $view['translator']->trans('newsletter.blockContent.senders.counter'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($campaign->getSenders() as $sender): ?>
                            <tr>
                                <td><a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_edit', ['id' => $sender->getId()]); ?>" class=""><?php echo $sender->getEmail(); ?></a></td>
                                <td><?php echo $sender->getName(); ?></td>
                                <td class="langStyle"><?php echo $sendersSendedCount[$sender->getId()]; ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modals -->
<div class="reveal" id="addSenderModal" data-reveal>
    <div class="add-sender" style="text-align: center;">
        <?php echo $view['form']->start($addSenderForm); ?>
            <div class="add-sender-input">
                <?php echo $view['form']->widget($addSenderForm['senders']); ?>
            </div>
            <div class="add-sender-button">
                <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                    <i class="icon-edit"></i> Save
                </button>
            </div>
        <?php echo $view['form']->end($addSenderForm); ?>
        <button class="close-button" data-close aria-label="Close modal" type="button">
            <span aria-hidden="true">&times;</span>
        </button>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_new', ['cid'=>$campaign->getId()]); ?>" class="button secondary" title="Create new sender">
            <span><i class="icon-folder-add"></i>Create new sender</span>
        </a>
    </div>
</div>
