<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_block_itemHTML_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.block.Show')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/block.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li><?php echo $view['translator']->trans('main-menu.template_extension'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.item'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_block_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.block.block'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_block_show', ['id' => $block->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.block.Show'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('block.listTitle'); ?> - <?php echo $view['translator']->trans('blockShow.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-th-large-2"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('blockShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowPages-dropdown">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowPages-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_block_edit', array('id' => $block->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT') & $block->getType()=='U'): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_block_delete', ['id' => $block->getId()]); ?>">
                                    <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('blockShow.deleteButton'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
             <h3 class="box-title"><i class="icon-th-large-2"></i>
                <span><?php echo $view['translator']->trans('catShow.listSubTitle'); ?> - <?php echo $block->getName(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
             <div class="row">
                <div class="large-10 columns">
                    <br>
                    <p><strong><?php echo $view['translator']->trans('blockNew.form.blockGroup'); ?>:</strong>
                    </p>
                </div>
            </div>
            <hr>
            <?php foreach ($block->getItems() as $item): ?>
                <div class="row">
                    <div class="large-2 columns">
                        <span class="info label secondary showItemButton"><?php echo $item->getName(); ?></span>
                    </div>
                    <div class="large-10 columns">
                        <div class="callout"><?php echo $item->getContent(); ?></div>
                    </div>
                </div>
                <hr>
            <?php endforeach; ?>
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_block_edit', array('id' => $block->getId())); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                            <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_block_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/block.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
