<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_admin_administrators_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.adminAdd')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/admin.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.administration'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.Administrators'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.AdminAdd'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('admin.listTitle'); ?> - <?php echo $view['translator']->trans('adminAdd.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-users-outline color-menu-administration"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('adminAdd.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<?php echo $view['form']->start($addNewForm) ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-user-add-outline"></i>
                <span><?php echo $view['translator']->trans('adminAdd.listSubTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('adminAdd.dataAdmin'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('adminAdd.dataAdminSub'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="wi-konatkt-form">
                        <?php if ($view['form']->errors($addNewForm)): ?>
                            <div class="alert callout small">
                                <?php echo $view['form']->errors($addNewForm); ?>
                            </div>
                        <?php endif; ?>
                        <?php echo $view['form']->errors($addNewForm) ?>
                        <div class="row">
                            <div class="medium-6 columns">
                                <?php echo $view['form']->label($addNewForm['login']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($addNewForm['login']) ?>
                                </div>
                                <?php echo ($view['form']->errors($addNewForm['login']) ? $view['form']->widget($addNewForm['login'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($addNewForm['login'])) ?>
                            </div>
                            <div class="medium-6 columns">
                                <?php echo $view['form']->label($addNewForm['email']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($addNewForm['email']) ?>
                                </div>
                                <?php echo ($view['form']->errors($addNewForm['email']) ? $view['form']->widget($addNewForm['email'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($addNewForm['email'])) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="medium-6 columns">
                                <?php echo $view['form']->label($addNewForm['password']['first']) ?>
                                    <div class="formAlert">
                                        <?php echo $view['form']->errors($addNewForm['password']['first']) ?>
                                    </div>
                                <?php echo ($view['form']->errors($addNewForm['password']['first']) ? $view['form']->widget($addNewForm['password']['first'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($addNewForm['password']['first'])) ?>
                            </div>
                            <div class="medium-6 columns">
                                <?php echo $view['form']->label($addNewForm['password']['second']) ?>
                                    <div class="formAlert">
                                        <?php echo $view['form']->errors($addNewForm['password']['second']) ?>
                                    </div>
                                <?php echo ($view['form']->errors($addNewForm['password']['first']) ? $view['form']->widget($addNewForm['password']['second'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($addNewForm['password']['second'])) ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('adminAdd.personalData'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('adminAdd.personalDataDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="wi-konatkt-form">
                        <div class="row">
                            <div class="medium-6 columns">
                                <?php echo $view['form']->label($addNewForm['firstName']) ?>
                                    <div class="formAlert">
                                        <?php echo $view['form']->errors($addNewForm['firstName']) ?>
                                    </div>
                                <?php echo ($view['form']->errors($addNewForm['firstName']) ? $view['form']->widget($addNewForm['firstName'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($addNewForm['firstName'])) ?>
                            </div>
                            <div class="medium-6 columns">
                                <?php echo $view['form']->label($addNewForm['lastName']) ?>
                                    <div class="formAlert">
                                        <?php echo $view['form']->errors($addNewForm['lastName']) ?>
                                    </div>
                                <?php echo ($view['form']->errors($addNewForm['lastName']) ? $view['form']->widget($addNewForm['lastName'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($addNewForm['lastName'])) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="medium-6 columns end">
                                <?php echo $view['form']->label($addNewForm['displayName']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($addNewForm['displayName']) ?>
                                </div>
                                <?php echo ($view['form']->errors($addNewForm['displayName']) ? $view['form']->widget($addNewForm['displayName'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($addNewForm['displayName'])) ?>
                            </div>
                            <div class="medium-6 columns end">
                                <?php echo $view['form']->label($addNewForm['job']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($addNewForm['job']) ?>
                                </div>
                                <?php echo ($view['form']->errors($addNewForm['job']) ? $view['form']->widget($addNewForm['job'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($addNewForm['job'])) ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('adminAdd.lockedData'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('adminAdd.lockedDataDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="wi-konatkt-form">
                        <div class="row">
                            <div class="medium-6 columns">
                                <?php echo $view['form']->label($addNewForm['lockedFrom']) ?>
                                <div class="formAlert"><?php echo $view['form']->errors($addNewForm['lockedFrom']); ?></div>
                                <?php echo $view['form']->widget($addNewForm['lockedFrom'], [
                                    'attr' => [
                                        'class' => ($addNewForm['lockedFrom']->vars['attr']['class'] ?? '') . (! $addNewForm['lockedFrom']->vars['valid'] ? ' callout alert' : null),
                                    ],
                                ]); ?>
                            </div>
                            <div class="medium-6 columns">
                                <?php echo $view['form']->label($addNewForm['lockedTo']) ?>
                                <div class="formAlert"><?php echo $view['form']->errors($addNewForm['lockedTo']); ?></div>
                                <?php echo $view['form']->widget($addNewForm['lockedTo'], [
                                    'attr' => [
                                        'class' => ($addNewForm['lockedTo']->vars['attr']['class'] ?? '') . (! $addNewForm['lockedTo']->vars['valid'] ? ' callout alert' : null),
                                    ],
                                ]); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end .timeline -->
    </div>
<div class="row">
    <div class=" columns">
        <div class="wi-konatkt-form">
            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
            </button>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_admin_administrators_index'); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
            </a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($addNewForm) ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/admin.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
