<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_admin_administrators_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.adminList')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/admin.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.administration'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.Administrators'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('admin.listTitle'); ?> - <?php echo $view['translator']->trans('adminList.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-users-outline color-menu-administration"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('adminList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
            <div class="box">
                <div class="box-header bg-transparent">
                    <!-- tools box -->
                    <div class="pull-right box-tools">
                        <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_EDIT')): ?>
                            <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_new') ?>" title="<?php echo $view['translator']->trans('adminList.add'); ?>" class="button tiny primary buttonAddNew">
                                <i class="icon-user-add-outline"></i>
                                <?php echo $view['translator']->trans('adminList.add'); ?>
                            </a>
                        <?php endif ?>
                    </div>
                    <h3 class="box-title"><i class="icon-th-list-outline"></i>
                        <span><?php echo $view['translator']->trans('adminList.listSubTitle'); ?></span>
                    </h3>
                    <input type="text" class="searchAdmin" data-table="AdminTable" placeholder="<?php echo $view['translator']->trans('adminList.search'); ?>">
                </div>
                <!-- /.box-header -->
                <div class="box-body " style="display: block;">
                    <div class="row">
                        <div class="columns tableResp">
                            <table id="AdminTable" class="display" style="width:100%">
                                <thead>
                                <tr>
                                    <th><?php echo $view['translator']->trans('adminData.Name'); ?></th>
                                    <th><?php echo $view['translator']->trans('adminData.login'); ?></th>
                                    <th><?php echo $view['translator']->trans('adminData.email'); ?></th>
                                    <th><?php echo $view['translator']->trans('adminData.job'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($administrators as $administrator): ?>

                                    <tr adminID="<?php echo $administrator->getid(); ?>">
                                        <td>
                                            <?php echo $administrator->getfirstName() ;?> <?php echo $administrator->getlastName() ;?>
                                        </td>
                                        <td>
                                            <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_show', array('id' => $administrator->getid())); ?>" title="<?php echo $view['translator']->trans('adminList.showAdmin'); ?>" ><b><?php echo $administrator->getlogin() ;?></b></a>
                                            <div class="buttonItemsBox">
                                                <div class="buttonsItems">
                                                    <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_show', ['id' => $administrator->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a> /
                                                    <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_EDIT')): ?>
                                                        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_edit', ['id' => $administrator->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a> /
                                                    <?php endif; ?>
                                                    <?php if ($view['security']->isGranted('ROLE_ADMINISTRATORS_EDIT_PERMISSIONS')): ?>
                                                        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_edit_permission', ['id' => $administrator->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('adminList.editPermission'); ?></a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo $administrator->getemail() ;?></td>
                                        <td><?php echo $administrator->getjob() ;?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- end .timeline -->
            </div>
            <!-- box -->
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/admin.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
