<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_admin_administrators_index')); ?>
<?php $view['form']->setTheme($formPermission, [':form']); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.adminEditPermission')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/admin.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.administration'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.Administrators'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_edit_permission', array('id' => $administrator->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.AdminEditPermission'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('admin.listTitle'); ?> - <?php echo $view['translator']->trans('adminEditPermission.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-users-outline color-menu-administration"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('adminEditPermission.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($formPermission); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-user-outline"></i>
                <span><?php echo $view['translator']->trans('adminEditPermission.listSubTitle'); ?>
                    - <?php echo(!empty($administrator->getfirstName()) ? $administrator->getfirstName() . ' ' . $administrator->getlastName() : $administrator->getlogin()); ?></span>
            </h3></div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('adminEditPermission.personalData'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('adminEditPermission.personalDataDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <?php echo $view['form']->errors($formPermission); ?>
                    <?php echo $view['form']->widget($formPermission); ?>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class="large-12 columns">
        <div class="wi-konatkt-form">
            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?></button>
            <?php echo $view['form']->end($formPermission); ?>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_admin_administrators_show', array('id' => $administrator->getId())); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
            </a>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/admin.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
