$(document).foundation();

$(function () {
    "use strict";
    $(document).ready(function () {
        $('.menuGenerate ul').addClass('vertical menu accordion-menu menuLast');
        $('.menuGenerate ul').attr('data-accordion-menu', true);
        $('.menuGenerate ul li a').prepend('<i class="fi-bookmark"></i>');
    });

    $('.buttonCommentSend').on('click', function () {
        var errorInfo = $('#errorInfo').val();
        var id = $('#idError').val();
        $.ajax({
            type: 'GET',
            url: Routing.generate('wi_admin_core_error_comment_send'),
            data: {
                id: id,
                errorInfo: errorInfo,
            },
            success: function (ret) {
                $('.successErrorInfo').removeClass('hide');
                $('#errorInfo').val('');
                $('.buttonCommentSend').addClass('hide');
            },
            error: function (ret) {

            }
        });
    });
    // Obsługa wyszukiwarki.
    $.widget( "custom.catcomplete", $.ui.autocomplete, {
        _create: function() {
            this._super();
            this.widget().menu( "option", "items", "> :not(.ui-autocomplete-category)" );
        },
        _renderMenu: function( ul, items ) {
            var that = this,
                currentCategory = "";
            $.each( items, function( index, item ) {
                var li;
                if ( item.category != currentCategory ) {
                    ul.append( "<li class='ui-autocomplete-category'>" + item.category + "</li>" );
                    currentCategory = item.category;
                }
                li = that._renderItemData( ul, item );
                if ( item.category ) {
                    li.attr( "aria-label", item.category + " : " + item.label );
                }
            });
        }
    });
    $('#search').on('keypress', function () {
        var value = $(this).val();
        if(value.length == 2) {
            $.ajax({
                type: "POST",
                url: Routing.generate('wi_front_core_search_get_autocomplete_data'),
                //dataType: "jsonp",
                data: {
                    search: value
                },
                success: function (data) {
                    $("#search").catcomplete({
                        delay: 0,
                        source: data,
                        select: function( event, ui ) {
                            if(ui.item.typ == 'page'){
                                window.location.href=Routing.generate('wi_front_page_index', {'id': ui.item.id, 'slug': ui.item.slug});
                            } else if(ui.item.typ == 'blog'){
                                window.location.href=Routing.generate('wi_front_news_show', {'id': ui.item.id, 'slug': ui.item.slug});
                            } else if(ui.item.typ == 'news'){
                                window.location.href=Routing.generate('wi_front_news_show', {'id': ui.item.id, 'slug': ui.item.slug});
                            }
                        }
                    });
                },
                error: function (data) {
                }
            });
        }
    });
});