$(document).foundation();

$(function () {

    'use strict';
    // Obsługa cookiesów
    $(document).ready(function () {
        if (!getCookie('cookiesDisable')) {
            $('.cookiesMessages').removeClass('hide');
        }
    });

   $('.cButtonClose').on('click', function () {
       setCookie('cookiesDisable', true, 365);
       $('.cookiesMessages').fadeOut("slow");
   });

   // Obsługa wyszukiwarki.
    $.widget( "custom.catcomplete", $.ui.autocomplete, {
        _create: function() {
            this._super();
            this.widget().menu( "option", "items", "> :not(.ui-autocomplete-category)" );
        },
        _renderMenu: function( ul, items ) {
            var that = this,
                currentCategory = "";
            $.each( items, function( index, item ) {
                var li;
                if ( item.category != currentCategory ) {
                    ul.append( "<li class='ui-autocomplete-category'>" + item.category + "</li>" );
                    currentCategory = item.category;
                }
                li = that._renderItemData( ul, item );
                if ( item.category ) {
                    li.attr( "aria-label", item.category + " : " + item.label );
                }
            });
        }
    });
    $('#search').on('keypress', function () {
        var value = $(this).val();
        if(value.length == 2) {
            $.ajax({
                type: "POST",
                url: Routing.generate('wi_front_core_search_get_autocomplete_data'),
                //dataType: "jsonp",
                data: {
                    search: value
                },
                success: function (data) {
                    $("#search").catcomplete({
                        delay: 0,
                        source: data,
                        select: function( event, ui ) {
                            if(ui.item.typ == 'page'){
                                window.location.href=Routing.generate('wi_front_page_index', {'id': ui.item.id, 'slug': ui.item.slug});
                            } else if(ui.item.typ == 'blog'){
                                window.location.href=Routing.generate('wi_front_news_show', {'id': ui.item.id, 'slug': ui.item.slug});
                            } else if(ui.item.typ == 'news'){
                                window.location.href=Routing.generate('wi_front_news_show', {'id': ui.item.id, 'slug': ui.item.slug});
                            }
                        }
                    });
                },
                error: function (data) {
                }
            });
        }
    });
});

function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays*24*60*60*1000));
    var expires = "expires="+ d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
    var name = cname + "=";
    var decodedCookie = decodeURIComponent(document.cookie);
    var ca = decodedCookie.split(';');
    for(var i = 0; i <ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}