// Cropper
$(function () {
    "use strict";

    var $windowModalEditCropper = $('#windowModalEditCropper');

    $('.InputFileHidden').on('change', function(e) {
        $('.komunikatBleduImage').addClass('hide');
        if ($windowModalEditCropper.length > 0) {
            $windowModalEditCropper.foundation('open');
        }
    });

    var $editCropperImage = $('#editCropperImage');
    var $editImageDataFromParameter = $('#editImageDataFromParameter');

    if($editCropperImage.length>0){
        var image = $editCropperImage[0];
        var paramWidth = $editImageDataFromParameter.attr('cropper-width');
        var paramHeight = $editImageDataFromParameter.attr('cropper-height');
        var originalImageURL = image.src;
        var uploadedImageURL;
        var cropper = new Cropper(image);
        var inputImage = $('#news_file_photo')[0];
        var file;

        if (URL) {
            inputImage.onchange = function () {
                var files = this.files;

                if (cropper && files && files.length) {
                    file = files[0];

                    if (/^image\/\w+/.test(file.type)) {
                        if (uploadedImageURL) {
                            URL.revokeObjectURL(uploadedImageURL);
                        }

                        image.src = uploadedImageURL = URL.createObjectURL(file);
                        cropper.destroy();
                        cropper = new Cropper(image, {
                            aspectRatio: paramWidth / paramHeight,
                            maxCanvasWidth: paramWidth,
                            maxCanvasHeight: paramHeight,
                            responsive: false,
                            autoCropArea: 0.9,
                            scalable: false,
                            cropBoxResizable: true,
                            dragMode: 'move',
                            rotatable: false,
                            toggleDragModeOnDblclick: true,
                            viewMode: 1,
                            crop: function(e) {
                                var x = e.detail.x;
                                var y = e.detail.y;
                                var width = e.detail.width;
                                var height = e.detail.height;
                                $('#crop_x').val(x);
                                $('#crop_y').val(y);
                                $('#crop_width').val(width);
                                $('#crop_height').val(height);
                            }
                        });
                    } else {
                        window.alert('Please choose an image file.');
                    }
                }
            };
        } else {
            inputImage.disabled = true;
            inputImage.parentNode.className += ' disabled';
        }

        $('#save_photo').click(function (e) {
            var varDataUrl = cropper.getCroppedCanvas().toDataURL('image/jpeg');

            $('#editCropperPreview').attr('src', varDataUrl);
            $('#cropSave').val(true);
            $('#editCropperPreview').attr('data-open', 'windowModalEditCropper');

            var formData = new FormData();
                formData.append('file', file, file.name);
                formData.append('x', $('#crop_x').val());
                formData.append('y', $('#crop_y').val());
                formData.append('width', $('#crop_width').val());
                formData.append('height', $('#crop_height').val());
                formData.append('cropSave', $('#cropSave').val());

            // Set up the request.
            /*var xhr = new XMLHttpRequest();
                xhr.open('POST', Routing.generate('wi_admin_news_save_ajax_image', { id: $('#editCropperImage').data('id') }), true);
                xhr.onload = function () {
                    if (xhr.status === 200) {
                        console.log('upload');
                    }
                };
                xhr.send(formData);*/

            /*$.post(
                Routing.generate('wi_admin_news_save_ajax_image', { id: $('#editCropperImage').data('id') }),
                formData,
                function (response) {
                    console.log(response);
                }
            );*/

            var fileInput = $('.InputFileHiddenEdit');
            var maxSize = fileInput.data('max-size');
            console.log(maxSize);
            if(file.size > maxSize){
                $('.komunikatBleduImage').removeClass('hide');
            } else {
                $.ajax({
                    type: 'POST',
                    dataType: 'JSON',
                    data: formData,
                    processData: false,
                    contentType: false,
                    url: Routing.generate('wi_admin_news_save_ajax_image', { id: $('#editCropperImage').data('id') }),
                    success: function (response) {
                        var imageUrl = $('#image-wrapper').data('image-url');
                        var $ul = $('#image-wrapper .image-list');

                        var $li = '<li data-id="'+response.id+'">' +
                            '<img src="'+imageUrl+response.name+'">' +
                            '<a href="'+response.delete_link+'" class="remove-image">Usuń</a>' +
                            '</li>';
                        $ul.append($li);
                        $editCropperImage.attr('src', originalImageURL);
                        $('#editCropperPreview').attr('src', originalImageURL);
                        uploadedImageURL = originalImageURL;
                    }
                });
            }



            console.log('save');
        });
    }

    $('#image-wrapper').on('click', '.remove-image', function (e) {
        e.preventDefault();
        var $li = $(this).parent();

        $.get($(this).attr('href'), function (response) {
            $li.remove();
        });
    });
});
