$(function () {
    "use strict";
    // Włączenie chosen - dodawanie i edycja newsa - wybór kategorii
    if($('.chosenSelect').length>0){
        $('.chosenSelect').chosen();
    }

    // Ukryj / rozwić wszystkie boxy
    $('.collapseAll').on('click', function () {
        $('.box').removeClass('collapsed-box');
        $('.collapseExpand').click();
    });
    $('.expandAll').on('click', function () {
        $('.collapsed-box .collapseExpand').click();
    });

    // External URL
    if($('.urlVal').length>0){
        $('.urlVal').on('focusout', function () {
            var wartosc = $(this).val();
            if(wartosc.indexOf('http://') > -1 || wartosc.indexOf('https://') > -1){
                $('.ifExternal').prop({checked: true});
            }
            else {
                $('.ifExternal').prop({checked: false});
            }
        })
    }

    // Delete form
    if($('#deleteItemMenu').length>0){
        $('#deleteItemMenu').change(function () {
            if(this.checked && $("#countChildren").attr("wartosc")==0){
                $('#itemMenuDeleteInput').removeAttr('disabled');
                $('#confirmDelete').css({opacity: "1", filter: "alpha(opacity=100)", "pointer-events": "all"});
            } else if(this.checked) {
                $('#confirmDelete').css({opacity: "1", filter: "alpha(opacity=100)", "pointer-events": "all"});
            } else {
                $('#confirmDelete').css({opacity: "0.3", filter: "alpha(opacity30)", "pointer-events": "none"});

            }
        });
        $('#deleteAll').change(function () {
            if(this.checked){
                $('#itemMenuDeleteInput').removeAttr('disabled');
                $('#confirmDeleteItemMenu').css({opacity: "0.3", filter: "alpha(opacity=30)", "pointer-events": "none"});
                $('#selectParent').css({opacity: "0.3", filter: "alpha(opacity=30)", "pointer-events": "none"});
            } else {
                $('#confirmDeleteItemMenu').css({opacity: "1", filter: "alpha(opacity=100)", "pointer-events": "all"});
                $('#selectParent').css({opacity: "1", filter: "alpha(opacity=100)", "pointer-events": "all"});
                if($('#newItemMenu').val()){
                    $('#itemMenuDeleteInput').removeAttr('disabled');
                } else {
                    $('#itemMenuDeleteInput').attr('disabled', 'disabled');
                }
            }
        });
        $('.chosenSelectParent').chosen().change(function () {
            if($('#newItemMenu').val()){
                $('#itemMenuDeleteInput').removeAttr('disabled');
            } else {
                $('#itemMenuDeleteInput').attr('disabled', 'disabled');
            }
        });
    }

    if($('#countLocation').length>0){
        var iloscMenu = $('#countLocation').attr('data-wartosc');
        var i;
        for(i=0; i<iloscMenu; i++){
            $('#nestableM' + i).nestable({
                group: i,
            })
                .on('change', function (e) {
                    var list   = e.length ? e : $(e.target);
                    var daneJson = window.JSON.stringify(list.nestable('serialize'));
                    $.ajax({
                        type: "POST",
                        url: Routing.generate('wi_admin_menu_ajax_save_list_parameters'),
                        data: {
                            daneJson: daneJson,
                        },
                        success: function (rep) {
                        },
                        complete: function () {
                        },
                        error: function (jqXHR, errorText, errorThrown) {
                        }
                    })
                });
        }
    }
    if($('.tooltipster-top').length>0){
        $('.tooltipster-top').tooltipster({
            position: "top"
        });
    }
});
