$(function () {
    // Przesyłanie plików.
    var $dropArea = $('#media-drop-area');

    if ($dropArea.length > 0) {
        var $currentNumber = $('#current-number');
        var $totalNumber = $('#total-number');
        var $uploadProgress = $('#upload-progress');

        $dropArea
            .on('dragenter', function () {$(this).addClass('dragover');})
            .on('dragover', function () {$(this).addClass('dragover');})
            .on('dragleave', function () {$(this).removeClass('dragover');})
            .on('drop', function () {$(this).removeClass('dragover');})
        ;
        // Przesyłanie plików.
        var uploader = new plupload.Uploader({
            browse_button: 'media-button',
            url: Routing.generate('wi_admin_media_upload', {d: $dropArea.data('directory')}),
            chunk_size: '200kb',
            max_retries: 3,
            unique_names: false,
            drop_element: 'media-drop-area',
            filters: {
                mime_types: [
                    {title: "Image files", extensions: WI_ALLOWED_EXTENSIONS }
                ]
            },
            init: {
                FilesAdded: function (up, files) {
                    $currentNumber.text('0');
                    $totalNumber.text(files.length);
                    uploader.start();
                    $('#upload-progress-wrapper').foundation('open');
                },
                UploadProgress: function (up, file) {
                    $uploadProgress
                        .find('span').width(up.total.percent + '%')
                        .find('p').text(up.total.percent + '%')
                    ;
                    $currentNumber.text(up.total.uploaded);
                },
                UploadComplete: function (up, files) {
                    $uploadProgress
                        .find('span').width(up.total.percent + '%')
                        .find('p').text(up.total.percent + '%')
                    ;
                    $currentNumber.text(up.total.uploaded);
                    location.reload();
                }
            }
        });

        // Inicjalizacja mechanizmu do przesyłania plików.
        uploader.init();
    }

    // Zmiana nazwy pliku/folderu.
    $('[data-open="rename-form"]').click(function (e) {
        var oldName = $(this).data('old-name');
        $('#rename_oldName').val(oldName)
    });

    // Usuwanie pliku/folderu.
    $('[data-open="delete-form"]').click(function (e) {
        var name = $(this).data('name');
        $('#delete_delete').val(name)
    });
});