$(function () {
    'use strict';
    

    // CodeEditor
    var $editorHtml = $('.editor-html');

    if ($editorHtml.length > 0) {
        var mixedMode = {
            name: "htmlmixed",
            scriptTypes: [
                {
                    matches: /\/x-handlebars-template|\/x-mustache/i,
                    mode: null
                },
                {
                    matches: /(text|application)\/(x-)?vb(a|script)/i,
                    mode: "vbscript"
                }
            ]
          };

        var myCodeMirror = CodeMirror.fromTextArea($editorHtml[0], {
            mode: mixedMode,
            lineNumbers: true,
        });
    }

    // Datepicker.
    var $datePicker = $('.datePicker');

    if ($datePicker.length > 0) {
        $datePicker.datetimepicker({
            timepicker:true,
            format:'d-m-Y H:i',
            closeOnDateSelect:true,
            scrollInput: false
        });
    }

    $('#delete_delete').change(function () {
        if (this.checked) {
            $('#AdminDeleteInput').removeAttr('disabled');
        } else {
            $('#AdminDeleteInput').attr('disabled', 'disabled');
        }
    });
});
